#include <assert.h>
#include <err.h>
#include <sqlite3.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "common.h"

static const char create_statement[] =
    "PRAGMA cache_size=16384;\n"
    "PRAGMA synchronous=off;\n"
    "BEGIN;\n"
    "DROP TABLE IF EXISTS branchtime;\n"
    "CREATE TABLE branchtime ("
      "branch integer NOT NULL REFERENCES branches(id) UNIQUE, "
      "date datetime NOT NULL"
    ")";

static const char branchtime_statement[] =
    "INSERT INTO branchtime SELECT b.id, (SELECT r.date FROM "
    "branchpoints2 bp, revision r WHERE b.id=bp.branch AND r.id=bp.revision "
    "ORDER BY r.date DESC LIMIT 1) FROM branches b WHERE "
    "EXISTS(SELECT * FROM branchpoints2 bp WHERE branch=b.id)";

static void
usage(void)
{
	fprintf(stderr, "Usage: %s database", getprogname());
	exit(1);
}

int
main(int argc, char **argv)
{
	sqlite3 *db;
	char *errmsg;
	int ch;

	while ((ch = getopt(argc, argv, "")) != -1) {
		switch (ch) {
		default:
			usage();
		}
	}
	argc -= optind;
	argv += optind;

	if (argc != 1)
		usage();

	if (sqlite3_open_v2(argv[0], &db, SQLITE_OPEN_READWRITE, NULL))
		errx(1, "database open failed: %s", sqlite3_errmsg(db));

	if (sqlite3_exec(db, create_statement, NULL, NULL,
	    &errmsg))
		errx(2, "schema update failed: %s", errmsg);
	if (sqlite3_exec(db, branchtime_statement, NULL, NULL, &errmsg))
		errx(2, "updateing branchtime failed: %s", errmsg);

	if (sqlite3_exec(db, "COMMIT", NULL, 0, &errmsg))
		errx(1, "commit failed: %s", errmsg);

	if (sqlite3_close(db))
		errx(1, "db close failed");
	return 0;
}
