#!/bin/sh
case $(uname) in
NetBSD)
	CC=gcc
	CFLAGS="-O2 -DSQLITE_NO_SYNC -DUSE_PREAD -Wall"
	LDFLAGS="-lz -lcrypto -lpthread"
	;;
Linux)
	CC=gcc
	CFLAGS="-O2 -DSQLITE_NO_SYNC -D_GNU_SOURCE -DUSE_PREAD -Wall"
	LDFLAGS="-lz -ldl -lcrypto -lpthread"
	;;
*)
	echo "Please add CFLAGS and LDFLAGS for your platform" >&2
	exit 1
	;;
esac
cd common
$CC $CFLAGS -Wall -c *.c
ar r libcommon.a *.o
cd ../01-import
$CC -o 01-import -I../common $CFLAGS *.c -L../common -lcommon $LDFLAGS
cd ../02-vendorbranches
$CC -o 02-vendorbranches -I../common $CFLAGS -Wall *.c -L../common -lcommon $LDFLAGS
cd ../03-branchtime
$CC -o 03-branchtime -I../common $CFLAGS -Wall *.c -L../common -lcommon $LDFLAGS
cd ../04-commit
$CC -o 04-commit -I../common $CFLAGS -Wall *.c -L../common -lcommon $LDFLAGS
cd ../99-warnings
$CC -o 99-warnings -I../common $CFLAGS -Wall *.c -L../common -lcommon $LDFLAGS
